/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.codefilarete.stalactite.engine.listener.SelectListener;

public class SelectListenerCollection<C, I>
implements SelectListener<C, I> {
    private final List<SelectListener<C, I>> selectListeners = new ArrayList<SelectListener<C, I>>();

    @Override
    public void beforeSelect(Iterable<I> ids) {
        this.selectListeners.forEach(listener -> listener.beforeSelect(ids));
    }

    @Override
    public void afterSelect(Set<? extends C> entities) {
        this.selectListeners.forEach(listener -> listener.afterSelect(entities));
    }

    @Override
    public void onSelectError(Iterable<I> ids, RuntimeException exception) {
        this.selectListeners.forEach(listener -> listener.onSelectError(ids, exception));
    }

    public void add(SelectListener<? extends C, I> selectListener) {
        this.selectListeners.add(selectListener);
    }

    public void moveTo(SelectListenerCollection<C, I> selectListener) {
        selectListener.selectListeners.addAll(this.selectListeners);
        this.selectListeners.clear();
    }
}

